/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWQuery;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWWorkElement;
import filenet.vw.api.VWWorkObject;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXMLUtil;
import filenet.vw.server.VWField;
import filenet.vw.server.VWFieldUtility;
import filenet.vw.server.VWWorkObjectID;
import java.io.Serializable;
import java.util.Date;

public final class VWStepElement
extends VWWorkElement
implements Serializable,
IVWtoXML {
    private static final long serialVersionUID = 119106L;
    public static final int FIELD_USER_DEFINED = 1;
    public static final int FIELD_SYSTEM_DEFINED = 2;
    public static final int FIELD_USER_AND_SYSTEM_DEFINED = 3;
    protected static final int FLAG_CAN_ATTACH = 1;
    protected static final int FLAG_CAN_RETURN = 2;
    protected static final int FLAG_CAN_REASSIGN = 4;
    protected static final int FLAG_CAN_VIEW_STATUS = 8;
    protected static final int FLAG_CAN_VIEW_HISTORY = 16;
    protected String comment = null;
    protected Date dateReceived;
    protected Date launchDate;
    private VWStepDefinition myStepDef;
    private String[] launchStepInitialFieldNames = null;
    private Object[] launchStepInitialFieldValues = null;
    private String processId;
    protected String NewWorkflowNumber = null;
    protected int NewWorkSpaceId = 0;
    protected VWSession serviceSession = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-07-19 23:46:48 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Van Vuong;5D6184897;vanvuong1@us.ibm.com (vvuong) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_460_Int/10 $";
    }

    protected VWStepElement(VWField[] fieldValues, VWWorkObjectID work_object_Id, VWQuery source) {
        super(fieldValues, work_object_Id, source);
    }

    protected VWStepElement(VWField[] fieldValues, VWSession source, boolean returnWobNum, String[] fieldNames, Object[] initialFieldValues) throws VWException {
        super(fieldValues, null, null);
        this.serviceSession = source;
        this.theCmdSession = source.getCmdSession();
        this.launchStepInitialFieldNames = fieldNames;
        this.launchStepInitialFieldValues = initialFieldValues;
    }

    public void doAbort() throws VWException {
        int saveType = 0;
        boolean isExceptionMap = this.getIsExceptionMap();
        VWException[] results = VWStepElement.unlockSave(new VWStepElement[]{this}, saveType, false, null, isExceptionMap ? this.getExceptionMap() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap, true, false);
        if (results != null && results[0] instanceof VWException) {
            throw results[0];
        }
    }

    public void doDispatch() throws VWException {
        if (this.workObjectId != null) {
            int saveType = 3;
            VWException[] results = VWStepElement.unlockSave(new VWStepElement[]{this}, saveType, false, null, this.isExceptionMap ? this.getExceptionMap() : this.getCallMap(), this.isExceptionMap ? this.getExceptionDescription() : null, this.isExceptionMap, true, true);
            if (results != null && results[0] instanceof VWException) {
                throw results[0];
            }
        } else {
            Object[] test;
            VWField[] initialFieldValues = null;
            int size = 0;
            if (this.launchStepInitialFieldNames != null) {
                initialFieldValues = new VWField[size += this.launchStepInitialFieldNames.length];
                for (int i = 0; i < this.launchStepInitialFieldNames.length; ++i) {
                    int fieldType;
                    Object fieldValue;
                    if (this.launchStepInitialFieldNames[i].equals("~F_WobNum") && i == 0) {
                        initialFieldValues[0] = new VWField("~F_WobNum", 3, this.getWorkObjectNumber(), true, 2, false, "");
                        continue;
                    }
                    boolean isArray = false;
                    if (this.launchStepInitialFieldValues[i] != null) {
                        isArray = this.launchStepInitialFieldValues[i].getClass().isArray();
                    }
                    if ((fieldValue = VWFieldUtility.convertFieldValue(this.launchStepInitialFieldValues[i], fieldType = VWFieldType.getVWFieldType(this.launchStepInitialFieldValues[i]), this.launchStepInitialFieldNames[i], isArray)) == null) continue;
                    initialFieldValues[i] = new VWField(this.launchStepInitialFieldNames[i], 3, this.launchStepInitialFieldValues[i], false, fieldType, isArray, "");
                    initialFieldValues[i].setValue(fieldValue, false);
                }
            }
            if ((test = this.theCmdSession.saveNewStepElement(super.getFields(), this.getAuthoredWorkClassName(), super.getWorkSpaceId(), initialFieldValues)) != null) {
                if (test[0] != null && test[0] instanceof String) {
                    this.NewWorkflowNumber = test[0].toString();
                }
                if (test[1] != null && test[1] instanceof Integer) {
                    this.NewWorkSpaceId = (Integer)test[1];
                }
            }
        }
    }

    public VWWorkObject fetchWorkObject(boolean lock, boolean overrideLock) throws VWException {
        if (this.workObjectId == null) {
            throw new VWException("vw.api.VWNewStepElement", "Cannot fetchWorkObject from a new StepElement.");
        }
        VWWorkObject resultObject = new VWWorkObject(null, this.workObjectId, this.sourceQuery);
        resultObject.fetchFields(1, lock, overrideLock);
        if (null == resultObject.workObjectId) {
            return null;
        }
        return resultObject;
    }

    public VWProcess fetchProcess() throws VWException {
        if (this.workObjectId == null && (this.NewWorkSpaceId == 0 || this.NewWorkflowNumber == null)) {
            throw new VWException("vw.api.VWNewStepElement", "Cannot fetchWorkObject from a new StepElement.");
        }
        VWProcess process = this.fetchProcess(this.getWorkSpaceId(), this.getWorkClassId(), this.getWorkflowNumber());
        process.setServiceSession(this.sourceQuery.querySource.serviceSession);
        return process;
    }

    public boolean getIsTracker() throws VWException {
        return super.getIsTracker();
    }

    public VWParameter[] getParameters(int fieldTypeFlag, int fieldCreatorFlag) throws VWException {
        int fType = 0;
        VWParameter[] fieldTypeParams = null;
        VWParameter[] parameters = super.getParameters();
        int systemField = 1;
        if (parameters != null && parameters.length > 0) {
            VWArrayHandler psHandler = new VWArrayHandler(20, 10);
            for (int i = 0; i < parameters.length; ++i) {
                fType = parameters[i].getFieldType();
                systemField = parameters[i].isSystemParameter() ? 2 : 1;
                if ((fieldCreatorFlag & systemField) != systemField || (fieldTypeFlag & fType) != fType) continue;
                fieldTypeParams = (VWParameter[])psHandler.addElementToArray(fieldTypeParams, parameters[i]);
            }
            return (VWParameter[])psHandler.getElements(fieldTypeParams);
        }
        return new VWParameter[0];
    }

    public VWParameter getParameter(String name) throws VWException {
        return super.getParameter(name);
    }

    public String getComment() throws VWException {
        this.comment = super.getComment();
        return this.comment;
    }

    public void setComment(String comment) throws VWException {
        this.comment = comment;
        this.internalSetParameterValue("F_Comment", comment, false);
    }

    public Date getDateReceived() throws VWException {
        return super.getDateReceived();
    }

    public String getExceptionDescription() {
        return super.getExceptionDescription();
    }

    public String getExceptionMap() {
        return super.getExceptionInstructionSheet();
    }

    public void setException(String workflowMapName, String description) throws VWException {
        super.setException(workflowMapName, description);
    }

    public Date getLaunchDate() throws VWException {
        return super.getLaunchDate();
    }

    public String getOriginator() throws VWException {
        String originator = super.getOriginator();
        return originator;
    }

    public VWParticipant getOriginatorPx() throws VWException {
        return super.getOriginatorPx();
    }

    public String getParticipantName() throws VWException {
        String participantName = super.getParticipantName();
        return participantName;
    }

    public VWParticipant getParticipantNamePx() throws VWException {
        return super.getParticipantNamePx();
    }

    public String[] getStepResponses() throws VWException {
        return super.getStepResponses();
    }

    public String getSelectedResponse() throws VWException {
        return super.getSelectedResponse();
    }

    public void setSelectedResponse(String response) throws VWException {
        super.setSelectedResponse(response);
    }

    public void doLock(boolean overrideLock) throws VWException {
        super.lock(overrideLock, 5);
    }

    public void doReturnToSource() throws VWException {
        if (!this.getCanReturnToSource()) {
            throw new VWException("vw.api.VWSEInvalidDoReturnToSource", "Can not return to source.");
        }
        boolean isExceptionMap = this.getIsExceptionMap();
        super.doReturn(new VWStepElement[]{this}, 3, isExceptionMap ? this.getExceptionMap() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap);
    }

    public void doRefresh(boolean lock, boolean overrideLock) throws VWException {
        this.fetchFields(2, lock, overrideLock);
    }

    public void doReassign(String participant, boolean delegateFlag, String queueName) throws VWException {
        boolean isExceptionMap = this.getIsExceptionMap();
        super.doReassign(new VWStepElement[]{this}, 3, null, participant, delegateFlag, queueName, isExceptionMap ? this.getExceptionMap() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap, 0L);
    }

    public void doReassignByDomain(String theDomainName, String participant, boolean delegateFlag, String queueName) throws VWException {
        boolean isExceptionMap = this.getIsExceptionMap();
        super.doReassign(new VWStepElement[]{this}, 3, theDomainName, participant, delegateFlag, queueName, isExceptionMap ? this.getExceptionMap() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap, 65537L);
    }

    public void doSave(boolean unlock) throws VWException {
        boolean isExceptionMap = this.getIsExceptionMap();
        int saveType = 3;
        VWException[] results = null;
        results = isExceptionMap ? VWStepElement.unlockSave(new VWStepElement[]{this}, saveType, false, null, unlock ? this.getExceptionMap() : null, unlock ? this.getExceptionDescription() : null, isExceptionMap, unlock, false) : VWStepElement.unlockSave(new VWStepElement[]{this}, saveType, false, null, unlock ? this.getCallMap() : null, null, isExceptionMap, unlock, false);
        if (results != null && results[0] instanceof VWException) {
            throw results[0];
        }
    }

    public static VWException[] doUnlockMany(VWStepElement[] stepElements, boolean save, boolean dispatch) throws VWException {
        int saveType = save ? 3 : 0;
        return VWStepElement.unlockSave(stepElements, saveType, false, null, null, null, false, true, dispatch);
    }

    public String getWorkObjectNumber() throws VWException {
        return super.getWorkObjectNumber();
    }

    public String getWorkObjectName() throws VWException {
        return super.getWorkObjectName();
    }

    public String getTag() throws VWException {
        return super.getTag();
    }

    public String getWorkClassName() throws VWException {
        return super.getWorkClassName();
    }

    public String getQueueName() throws VWException {
        return super.getWorkPerformerClassName();
    }

    public String getOperationName() throws VWException {
        return super.getOperationName();
    }

    public String getStepName() throws VWException {
        return super.getStepName();
    }

    public String getAuthoredStepName() throws VWException {
        return super.getAuthoredStepName();
    }

    public String toString() {
        String name = null;
        try {
            name = this.getWorkObjectName();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return name;
    }

    public Date getDeadline() throws VWException {
        return super.getDeadline();
    }

    public Date getReminder() throws VWException {
        return super.getReminder();
    }

    public String getSubject() throws VWException {
        return super.getSubject();
    }

    public String getWorkflowName() throws VWException {
        return super.getWorkClassName();
    }

    public void setParameters(VWParameter[] parameters, boolean compareValues) throws VWException {
        if (parameters == null) {
            throw new VWException("vw.api.SESetParametersNull", "The parameter ''parameters'' is null.");
        }
        if (parameters != null && parameters.length > 0) {
            String parameterName = null;
            Object parameterValue = null;
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] == null) continue;
                parameterName = parameters[i].getName();
                if (parameterName == null) {
                    throw new VWException("vw.api.SESetParametersNameIsNull", "The parameter name is null.");
                }
                if (parameters[i].getMode() == 1) {
                    throw new VWException("vw.api.SESetParametersModeIsIN", "Cannot set the value for parameter {0}.  The mode for this parameter is set to IN.", parameterName);
                }
                parameterValue = parameters[i].getValue();
                if (parameterName == null) continue;
                this.setParameterValue(parameterName, parameterValue, compareValues);
            }
        }
    }

    public String getRosterName() throws VWException {
        return super.getRosterName();
    }

    public String getWorkFlowNumber() throws VWException {
        return super.getWorkFlowNumber();
    }

    public String getWorkflowNumber() throws VWException {
        if (this.workObjectId == null) {
            return this.NewWorkflowNumber;
        }
        return super.getWorkFlowNumber();
    }

    public boolean hasParameterName(String parameterName) throws VWException {
        return super.hasFieldName(parameterName);
    }

    public String getStepDescription() throws VWException {
        return super.getStepDescription();
    }

    public String[] getParameterNames() {
        return super.getFieldNames();
    }

    public Object getParameterValue(String parameterName) throws VWException {
        return super.getFieldValue(parameterName);
    }

    public void setParameterValue(String parameterName, Object parameterValue, boolean compareValue) throws VWException {
        block12: {
            block13: {
                VWField field = this.getField(parameterName);
                if (field == null) {
                    throw new VWException("vw.api.SEParameterNotFound", "setParameterValue:parameter name not found.");
                }
                if (field.getMode() == 1) {
                    throw new VWException("vw.api.SEParameterNotWritable", "setParameterValue:parameter cannot be modified since it is MODE_TYPE_IN.");
                }
                int fieldMode = field.getMode();
                if (field.getMode() == 1) {
                    throw new VWException("vw.api.SEFieldNotWritable", "setParameterValue:field cannot be modified since it is MODE_IN.");
                }
                if (parameterValue != null) break block12;
                if (!field.isArray()) break block13;
                switch (field.getType()) {
                    case 4: {
                        parameterValue = new Boolean[]{};
                        break block12;
                    }
                    case 1: {
                        parameterValue = new Integer[]{};
                        break block12;
                    }
                    case 8: {
                        parameterValue = new Double[]{};
                        break block12;
                    }
                    case 16: {
                        parameterValue = new Date[]{};
                        break block12;
                    }
                    case 2: {
                        parameterValue = new String[]{};
                        break block12;
                    }
                    case 32: {
                        parameterValue = new VWAttachment[]{};
                        break block12;
                    }
                    case 64: {
                        parameterValue = new VWParticipant[]{};
                        break block12;
                    }
                    default: {
                        throw new VWException("vw.api.SEParameterUndefined", "setparameterValue:parameter type is undefined.");
                    }
                }
            }
            throw new VWException("vw.api.SEParameterValueNull", "setparameterValue:parameter value cannot be null.");
        }
        super.setFieldValue(parameterName, parameterValue, compareValue);
    }

    protected void internalSetParameterValue(String parameterName, Object parameterValue, boolean compareValue) throws VWException {
        VWField field = this.getField(parameterName);
        if (field == null) {
            throw new VWException("vw.api.SEParameterNotFound", "internalSetParameterValue:parameter name not found.");
        }
        if (field.getMode() == 1) {
            throw new VWException("vw.api.SEParameterNotWritable", "internalSetParameterValue:parameter cannot be modified since it is MODE_TYPE_IN.");
        }
        super.setFieldValue(parameterName, parameterValue, compareValue);
    }

    public boolean getCanReassign() throws VWException {
        int flag = super.getUIFlag();
        return (flag & 4) == 4;
    }

    public boolean getCanReturnToSource() throws VWException {
        int flag = super.getUIFlag();
        return (flag & 2) == 2;
    }

    public boolean getCanViewStatus() throws VWException {
        int flag = super.getUIFlag();
        return (flag & 8) == 8;
    }

    public String getCurrentQueueName() throws VWException {
        return super.getCurrentQueueName();
    }

    public int getOverdue() throws VWException {
        return super.getOverdue();
    }

    public int getWorkOrderId() throws VWException {
        return super.getWorkOrderId();
    }

    public String getSourceDoc() throws VWException {
        return super.getSourceDoc();
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        String tmpS;
        Date tmpD;
        if (theBuffer == null) {
            throw new VWException("vw.api.VWAttributeInfoNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        String INDENT_3 = INDENT_2 + "\t";
        String INDENT_4 = INDENT_3 + "\t";
        theBuffer.append(INDENT_0 + "<" + "StepElement" + "\n");
        VWParticipant originatorPx = this.getOriginatorPx();
        if (originatorPx != null) {
            if (originatorPx.getDisplayName() != null) {
                theBuffer.append(INDENT_1 + "LaunchedBy" + "=\"" + VWXMLHandler.toXMLString(originatorPx.getDisplayName()) + "\"\n");
            } else {
                theBuffer.append(INDENT_1 + "LaunchedBy" + "=\"" + VWXMLHandler.toXMLString(originatorPx.getParticipantName()) + "\"\n");
            }
        }
        if ((tmpD = this.getLaunchDate()) != null) {
            theBuffer.append(INDENT_1 + "LaunchedOn" + "=\"" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString(tmpD)) + "\"\n");
        }
        if ((tmpD = this.getDateReceived()) != null) {
            theBuffer.append(INDENT_1 + "ReceivedOn" + "=\"" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString(tmpD)) + "\"\n");
        }
        if ((tmpD = this.getDeadline()) != null) {
            theBuffer.append(INDENT_1 + "Deadline" + "=\"" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString(tmpD)) + "\"\n");
        }
        if ((tmpD = this.getReminder()) != null) {
            theBuffer.append(INDENT_1 + "Reminder" + "=\"" + VWXMLHandler.toXMLString(VWXMLUtil.convertDateToUTCString(tmpD)) + "\"\n");
        }
        if ((tmpS = this.getSubject()) != null) {
            theBuffer.append(INDENT_1 + "Subject" + "=\"" + VWXMLHandler.toXMLString(tmpS) + "\"\n");
        }
        if ((tmpS = this.getStepDescription()) != null) {
            theBuffer.append(INDENT_1 + "Description" + "=\"" + VWXMLHandler.toXMLString(tmpS) + "\"\n");
        }
        if ((tmpS = this.getStepName()) != null) {
            theBuffer.append(INDENT_1 + "StepName" + "=\"" + VWXMLHandler.toXMLString(tmpS) + "\"\n");
        }
        if ((tmpS = this.getAuthoredStepName()) != null) {
            theBuffer.append(INDENT_1 + "AuthoredStepName" + "=\"" + VWXMLHandler.toXMLString(tmpS) + "\"\n");
        }
        theBuffer.append(INDENT_1 + "WOBName" + "=\"" + VWXMLHandler.toXMLString(this.getWorkObjectName()) + "\"\n");
        theBuffer.append(INDENT_1 + "WOBNumber" + "=\"" + VWXMLHandler.toXMLString(this.getWorkObjectNumber()) + "\"\n");
        theBuffer.append(INDENT_1 + "WorkflowName" + "=\"" + VWXMLHandler.toXMLString(this.getWorkflowName()) + "\"\n");
        theBuffer.append(INDENT_1 + "WorkflowNumber" + "=\"" + VWXMLHandler.toXMLString(this.getWorkflowNumber()) + "\"\n");
        theBuffer.append(INDENT_1 + "WorkClassName" + "=\"" + VWXMLHandler.toXMLString(this.getWorkClassName()) + "\"\n");
        theBuffer.append(INDENT_1 + "Tag" + "=\"" + VWXMLHandler.toXMLString(this.getTag()) + "\"\n");
        theBuffer.append(INDENT_1 + "RosterName" + "=\"" + VWXMLHandler.toXMLString(this.getRosterName()) + "\"\n");
        theBuffer.append(INDENT_1 + "QueueName" + "=\"" + VWXMLHandler.toXMLString(this.getQueueName()) + "\"\n");
        theBuffer.append(INDENT_1 + "CurrentQueueName" + "=\"" + VWXMLHandler.toXMLString(this.getCurrentQueueName()) + "\"\n");
        VWParticipant participantPx = this.getParticipantNamePx();
        if (participantPx != null) {
            if (participantPx.getDisplayName() != null) {
                theBuffer.append(INDENT_1 + "ParticipantName" + "=\"" + VWXMLHandler.toXMLString(participantPx.getDisplayName()) + "\"\n");
            } else {
                theBuffer.append(INDENT_1 + "ParticipantName" + "=\"" + VWXMLHandler.toXMLString(participantPx.getParticipantName()) + "\"\n");
            }
        }
        theBuffer.append(INDENT_1 + "OperationName" + "=\"" + VWXMLHandler.toXMLString(this.getOperationName()) + "\"\n");
        theBuffer.append(INDENT_1 + "CurrentMapName" + "=\"" + VWXMLHandler.toXMLString(this.getCurrentMapName()) + "\"\n");
        theBuffer.append(INDENT_1 + "ExceptionMapName" + "=\"" + VWXMLHandler.toXMLString(this.getExceptionMap()) + "\"\n");
        theBuffer.append(INDENT_1 + "ExceptionDescription" + "=\"" + VWXMLHandler.toXMLString(this.getExceptionDescription()) + "\"\n");
        theBuffer.append(INDENT_1 + "IsTracker" + "=\"" + VWXMLHandler.booleanToString(this.getIsTracker()) + "\"\n");
        int overD = this.getOverdue();
        theBuffer.append(INDENT_1 + "Overdue" + "=");
        switch (overD) {
            case 0: {
                theBuffer.append("\"NotOverdue\"\n");
                break;
            }
            case 1: {
                theBuffer.append("\"ReminderPast\"\n");
                break;
            }
            case 2: {
                theBuffer.append("\"DeadlinePast\"\n");
                break;
            }
            default: {
                theBuffer.append("\"InvalidOverdueValue\"\n");
            }
        }
        tmpS = this.getComment();
        if (tmpS != null) {
            theBuffer.append(INDENT_1 + "Comment" + "=\"" + VWXMLHandler.toXMLString(tmpS) + "\"\n");
        }
        theBuffer.append(INDENT_1 + "CanReassign" + "=\"" + VWXMLHandler.booleanToString(this.getCanReassign()) + "\"\n");
        theBuffer.append(INDENT_1 + "CanViewStatus" + "=\"" + VWXMLHandler.booleanToString(this.getCanViewStatus()) + "\"\n");
        theBuffer.append(INDENT_1 + "CanViewHistory" + "=\"" + VWXMLHandler.booleanToString(this.getCanViewHistory()) + "\"\n");
        theBuffer.append(INDENT_1 + "CanReturnToSource" + "=\"" + VWXMLHandler.booleanToString(this.getCanReturnToSource()) + "\"");
        theBuffer.append(">\n");
        if (originatorPx != null) {
            theBuffer.append(INDENT_1 + "<" + "Originator" + ">\n");
            originatorPx.toXML(theBuffer, INDENT_2);
            theBuffer.append(INDENT_1 + "</" + "Originator" + ">\n");
        }
        if (participantPx != null) {
            theBuffer.append(INDENT_1 + "<" + "BoundUser" + ">\n");
            participantPx.toXML(theBuffer, INDENT_2);
            theBuffer.append(INDENT_1 + "</" + "BoundUser" + ">\n");
        }
        theBuffer.append(INDENT_1 + "<" + "Responses");
        String[] resps = this.getStepResponses();
        if (resps != null) {
            tmpS = this.getSelectedResponse();
            if (tmpS != null) {
                theBuffer.append(" Selected=\"" + VWXMLHandler.toXMLString(tmpS) + "\"");
            }
            theBuffer.append(">\n");
            for (int i = 0; i < resps.length; ++i) {
                theBuffer.append(INDENT_2 + "<" + "Response" + ">" + VWXMLHandler.toXMLString(resps[i]) + "</" + "Response" + ">\n");
            }
            theBuffer.append(INDENT_1 + "</" + "Responses" + ">\n");
        } else {
            theBuffer.append("/>\n");
        }
        theBuffer.append(INDENT_1 + "<" + "Parameters");
        VWParameter[] pars = this.getParameters(767, 3);
        if (pars != null) {
            theBuffer.append(">\n");
            int arrayCount = pars.length;
            for (int i = 0; i < arrayCount; ++i) {
                pars[i].toXML(theBuffer);
            }
            theBuffer.append(INDENT_1 + "</" + "Parameters" + ">\n");
        } else {
            theBuffer.append("/>\n");
        }
        VWStepProcessorInfo spInfo = this.fetchStepProcessorInfo();
        if (spInfo != null) {
            spInfo.toXML(theBuffer);
        }
        theBuffer.append(INDENT_0 + "</" + "StepElement" + ">\n");
    }

    public boolean getIsLaunchStep() {
        return this.workObjectId == null;
    }

    public void setCallMap(String aMapName) throws VWException {
        if (aMapName == null) {
            throw new VWException("vw.api.VWSetCallMapNameNull", "null is not a valid map name.");
        }
        super.setCallMap(aMapName);
    }

    public String getCallMap() {
        return super.getCallMap();
    }

    public int getWorkSpaceId() throws VWException {
        if (this.workObjectId == null) {
            return this.NewWorkSpaceId;
        }
        return super.getWorkSpaceId();
    }

    public int getWorkClassId() throws VWException {
        return super.getWorkClassId();
    }

    public boolean getCanViewHistory() throws VWException {
        int flag = super.getUIFlag();
        return (flag & 0x10) == 16;
    }

    public String getAuthoredCurrentMapName() throws VWException {
        return super.getAuthoredInstructionSheetName();
    }

    public String getCurrentMapName() throws VWException {
        return super.getInstructionSheetName();
    }

    public VWParticipant getLockedUserPx() throws VWException {
        return super.getLockedUserPx();
    }

    protected int getProcessorId() throws VWException {
        return super.getProcessorId();
    }

    public VWStepProcessorInfo fetchStepProcessorInfo() throws VWException {
        VWStepProcessorInfo result = null;
        if (this.serviceSession != null) {
            int processorId = this.getProcessorId();
            if (processorId != -1) {
                result = this.theCmdSession.getStepProcessorById(processorId, this.serviceSession.webAppId);
            }
            if (result != null) {
                result.setDefaultWebAppId(this.serviceSession.getDefaultWebApplication());
                result.setIsolatedRegionWebAppId(this.serviceSession.getIsolatedRegionWebApp());
            }
        } else {
            result = super.fetchStepProcessorInfo();
        }
        return result;
    }

    public Object getProperty(String propertyName) throws VWException {
        String authFieldName = this.authorStr(propertyName);
        return this.getFieldValue("*" + authFieldName, false);
    }
}

